<?php
session_start();
require_once '../config/db.php';
require_once '../auth/auth.php';

requireLogin();
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit();
}

try {
    $invoice_id = intval($_GET['id'] ?? 0);
    
    if ($invoice_id <= 0) {
        echo json_encode(['success' => false, 'message' => 'Invalid invoice ID']);
        exit();
    }
    
    // Check if payments table exists
    $stmt = $pdo->query("SHOW TABLES LIKE 'payments'");
    if ($stmt->rowCount() === 0) {
        // Payments table doesn't exist, return empty payments
        echo json_encode([
            'success' => true,
            'payments' => [],
            'total_paid' => 0
        ]);
        exit();
    }
    
    // Get payments for this invoice
    $stmt = $pdo->prepare("
        SELECT 
            p.id,
            p.payment_method,
            p.payment_date,
            p.amount,
            p.reference_number,
            p.notes,
            p.created_at,
            u.username as processed_by_name
        FROM payments p
        LEFT JOIN users u ON p.processed_by = u.id
        WHERE p.invoice_id = ?
        ORDER BY p.created_at DESC
    ");
    
    $stmt->execute([$invoice_id]);
    $payments = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Calculate total paid
    $totalPaid = array_sum(array_column($payments, 'amount'));
    
    echo json_encode([
        'success' => true,
        'payments' => $payments,
        'total_paid' => $totalPaid
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Error fetching payments: ' . $e->getMessage()
    ]);
} 